
#ifndef SWARMTAXISIFACE_H_
#define SWARMTAXISIFACE_H_

class SwarmTaxisIface {

	private:
		bool reached;				
		double linearSpeed;
		double angularSpeed;
		double desiredTurningDegree;
		double degreeTurned;
		double avoidanceRadius;

	protected:
		bool anyRobotToAvoid;         
	
	public:

		void SetReached(bool i) {reached = i;}
		void SetLinearSpeed(double i) {linearSpeed = i;}
		void SetAngularSpeed(double i) {angularSpeed = i;}
		void SetDesiredTurningDegree(double i) {desiredTurningDegree = i;}
		void SetDegreeTurned(double i) {degreeTurned = i;}
		void SetAvoidanceRadius(double i) {avoidanceRadius = i;}
		bool GetReached() {return reached;}
		double GetLinearSpeed() {return linearSpeed;}
		double GetAngularSpeed() {return angularSpeed;}
		double GetDesiredTurningDegree() {return desiredTurningDegree;}
		double GetDegreeTurned() {return degreeTurned;}
		double GetAvoidanceRadius() {return avoidanceRadius;}

		void RaiseAnyRobotToAvoid() {anyRobotToAvoid = true;}

		SwarmTaxisIface();
		virtual void MoveForward(double i);
		virtual void RotateClockwise(double i);
		virtual void RotateAntiClockwise(double i);
		virtual void Turn();
		virtual void UpdateAvoidanceRadius();

		virtual void CalcCoherenceHeading() {}
		virtual void CalcAvoidanceHeading() {}
		virtual bool CheckIlluminationStatus() {return false;}

};

#endif


