
#include "SwarmTaxisFSM.h"

SwarmTaxisFSM::SwarmTaxisFSM() : TimerA(new Timer())
{
	this->GetTimerA()->StartTimer();
	currentState = Forward;
}

void SwarmTaxisFSM::MakeTransition() {
	switch (currentState) {
		case Forward:
			if (anyRobotToAvoid) {
				currentState = Avoidance;
			}
			if (this->GetTimerA()->GetCounter() > 25) {
				currentState = Coherence;
				this->GetTimerA()->ResetTimer();
			}
			break;
		case Coherence:
			if (GetReached() == true) {
				this->GetTimerA()->StartTimer();
				currentState = Forward;
			}
			break;
		case Avoidance:
			if (GetReached() == true) {
				this->GetTimerA()->StartTimer();
				currentState = Forward;
			}
			break;
		default:
			break;
	}
}

void SwarmTaxisFSM::ExecuteEntryAction() {
	switch (currentState) {
		case Forward:
			Entry_Action_Forward();
		    break;
		case Coherence:
			Entry_Action_Coherence();
			break;
		case Avoidance:
			Entry_Action_Avoidance();
			break;
		default:
			break;
	}
}

void SwarmTaxisFSM::ClearEvents() {
	anyRobotToAvoid = false;
}

void SwarmTaxisFSM::RunSwarmTaxisFSM() {
	ExecuteEntryAction();
	MakeTransition();
	ClearEvents();
}

void SwarmTaxisFSM::Entry_Action_Forward() {
	SetReached(false);
	UpdateAvoidanceRadius();
	MoveForward(6.4);
}

void SwarmTaxisFSM::Entry_Action_Coherence() {
	CalcCoherenceHeading();
	Turn();
}

void SwarmTaxisFSM::Entry_Action_Avoidance() {
	CalcAvoidanceHeading();
	Turn();
}
